/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;

public final class TableNameSchemaNameMapping {
    private final Map<LogicTableName, String> mapping;

    public TableNameSchemaNameMapping(Map<String, String> tableSchemaMap) {
        if (null == tableSchemaMap) {
            this.mapping = Collections.emptyMap();
            return;
        }
        HashMap<LogicTableName, String> mapping = new HashMap<LogicTableName, String>();
        tableSchemaMap.forEach((tableName, schemaName) -> {
            if (null != schemaName) {
                mapping.put(new LogicTableName((String)tableName), (String)schemaName);
            }
        });
        this.mapping = mapping;
    }

    public String getSchemaName(String logicTableName) {
        return this.mapping.get(new LogicTableName(logicTableName));
    }

    public String getSchemaName(LogicTableName logicTableName) {
        return this.mapping.get(logicTableName);
    }

    @Generated
    public String toString() {
        return "TableNameSchemaNameMapping(mapping=" + this.mapping + ")";
    }
}

