/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;

public final class TableNameSchemaNameMapping {
    private final Map<LogicTableName, String> mapping;

    public static Map<LogicTableName, String> convert(Map<String, List<String>> schemaTablesMap) {
        LinkedHashMap<LogicTableName, String> result = new LinkedHashMap<LogicTableName, String>();
        schemaTablesMap.forEach((schemaName, tableNames) -> {
            for (String each : tableNames) {
                result.put(new LogicTableName(each), (String)schemaName);
            }
        });
        return result;
    }

    public static Map<LogicTableName, String> convert(String schemaName, Collection<String> tables) {
        LinkedHashMap<LogicTableName, String> result = new LinkedHashMap<LogicTableName, String>();
        for (String each : tables) {
            result.put(new LogicTableName(each), schemaName);
        }
        return result;
    }

    public String getSchemaName(String logicTableName) {
        return this.mapping.get(new LogicTableName(logicTableName));
    }

    public String getSchemaName(LogicTableName logicTableName) {
        return this.mapping.get(logicTableName);
    }

    @Generated
    public TableNameSchemaNameMapping(Map<LogicTableName, String> mapping) {
        this.mapping = mapping;
    }

    @Generated
    public String toString() {
        return "TableNameSchemaNameMapping(mapping=" + this.mapping + ")";
    }
}

